// Infopage.cpp : implementation file
//

#include "stdafx.h"
#include "Ultima_C++Demo.h"
#include "MainSheet.h"
#include "Infopage.h"

//#############################################################################

// CInfoPage dialog
IMPLEMENT_DYNAMIC(CInfoPage, CPropertyPage)

CInfoPage::CInfoPage() : CPropertyPage(CInfoPage::IDD)
{
}

CInfoPage::~CInfoPage()
{
}

void CInfoPage::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_INFOMSG, InfoMessage);
}

BEGIN_MESSAGE_MAP(CInfoPage, CPropertyPage)
	ON_BN_CLICKED(IDC_BTN_PRINTERSTATUS,  &CInfoPage::OnBnClickedPrinterStatusBtn)
	ON_BN_CLICKED(IDC_BTN_PRINTERINFO,    &CInfoPage::OnBnClickedPrinterInfoBtn)
	ON_BN_CLICKED(IDC_BTN_INFOMSG_CLR,    &CInfoPage::OnBnClickedInfoMsgClrBtn)
	ON_BN_CLICKED(IDC_BTN_GETVERSION,     &CInfoPage::OnBnClickedSDKVersionBtn)
	ON_BN_CLICKED(IDC_BTN_CONNECTIONTYPE, &CInfoPage::OnBnClickedConnectionTypeBtn)
	ON_BN_CLICKED(IDC_BTN_PRINTERMODEL,   &CInfoPage::OnBnClickedPrinterModelBtn)
	ON_BN_CLICKED(IDC_BTN_LASTMESSAGE,    &CInfoPage::OnBnClickedLastMessageBtn)
	ON_BN_CLICKED(IDC_BTN_SDKBITS,        &CInfoPage::OnBnClickedSDKBitsBtn)
	ON_BN_CLICKED(IDC_BTN_TEMPERATURE,    &CInfoPage::OnBnClickedTemperatureBtn)
	ON_BN_CLICKED(IDC_BTN_PRINTERTYPE, &CInfoPage::OnBnClickedBtnPrintertype)
END_MESSAGE_MAP()

//#############################################################################

// CInfoPage message handlers
BOOL CInfoPage::OnInitDialog()
{
	CPropertyPage::OnInitDialog();

	Parent = (CMainSheet *)GetParent();

	return TRUE;  // return TRUE  unless you set the focus to a control
}

//****************************************************************************

void CInfoPage::OutputBurstMessage(TCHAR *str)
{
	int end;
	TCHAR temp[2] = {0, 0};

	while (*str != '\0')
	{
		end = InfoMessage.GetWindowTextLength();
		InfoMessage.SetSel(end, end);
		if (*str == '\n')
		{
			InfoMessage.ReplaceSel(_T("\r\n"));
		}
		else
		{
			temp[0] = *str;
			InfoMessage.ReplaceSel(temp);
		}
		str++;
	}

	//Extra Line Feed at end
	InfoMessage.ReplaceSel(_T("\r\n\r\n"));
}

void CInfoPage::OnBnClickedInfoMsgClrBtn()
{
	InfoMessage.SetWindowText(_T(""));
}

void CInfoPage::AddInfoMessage(CString pMessage)
{
	Parent->AddString(&InfoMessage, pMessage);
}

//****************************************************************************

void CInfoPage::OnBnClickedLastMessageBtn()
{
	//Get SDK function address
	PFNIDLASTMSG pFnLastMessage = (PFNIDLASTMSG)GetProcAddress(Parent->hLib, IDFN_LASTMESSAGE);
	if (!pFnLastMessage)
	{
		FUNCTION_NOT_ACCESSED(GetLastMessage);
	}

	else
	{
		//Call the SDK to get the buffer size
		DWORD dwMsgSize = 0;
		int SDKReturn = (*pFnLastMessage)(Parent->hSession, NULL, &dwMsgSize);
		if (SDKReturn != ID_MORE_DATA)
		{
			DISPLAY_ERROR(GetLastMessageSize, SDKReturn);
		}
		else
		{
			//Allocate the buffer
			TCHAR *szMessage = new TCHAR[dwMsgSize];

			//Call the SDK to get the last message
			int SDKReturn = (*pFnLastMessage)(Parent->hSession, szMessage, &dwMsgSize);
			if (SDKReturn != ID_SUCCESS)
			{
				DISPLAY_ERROR(GetLastMessage, SDKReturn);
			}
			else
			{
				//Update the message box
				OutputBurstMessage(szMessage);
			}

			delete[] szMessage;
		}
	}
}

//****************************************************************************

void CInfoPage::OnBnClickedPrinterStatusBtn()
{
	CWaitCursor wait;

	//Get SDK function address
	PFNIDSTATUS pFnPrinterStatus = (PFNIDSTATUS)GetProcAddress(Parent->hLib, "ID_PrinterStatus");
	if (!pFnPrinterStatus)
	{
		FUNCTION_NOT_ACCESSED(GetPrinterStatus);
	}

	else
	{
		//Call the SDK to get the printer status
		int SDKReturn = (*pFnPrinterStatus)(Parent->hSession);

		//Update the message box
		CString temp_string;
		switch (SDKReturn)
		{
		case ID_STATUS_READY:   temp_string = _T("READY");   break;
		case ID_STATUS_OFFLINE: temp_string = _T("OFFLINE"); break;
		case ID_STATUS_ERROR:   temp_string = _T("ERROR");   break;
		case ID_STATUS_BUSY:    temp_string = _T("BUSY");    break;
		}

		AddInfoMessage(_T("Printer: ") + temp_string);
		AddInfoMessage(_T(""));
	}
}

//****************************************************************************

void CInfoPage::OnBnClickedPrinterInfoBtn()
{
	ULTIMA_INFO PrinterInfo;
	CWaitCursor  wait;

	//Get SDK function address
	PFNIDPRINTERINFO pFnPrinterInfo = (PFNIDPRINTERINFO)GetProcAddress(Parent->hLib, "ID_PrinterInfo");
	if (!pFnPrinterInfo)
	{
		FUNCTION_NOT_ACCESSED(ID_PrinterInfo);
		return;
	}

	//Call the SDK to get the Printer Info
	int SDKReturn = (*pFnPrinterInfo)(Parent->hSession, &PrinterInfo);
	if (SDKReturn != ID_SUCCESS)
	{
		DISPLAY_ERROR(GetPrinterInfo, SDKReturn);
		return;
	}

	//Output to the message box
	CString temp_string;
	AddInfoMessage(_T("FirmwareVersion: ") + CString(PrinterInfo.firmware_version, sizeof(PrinterInfo.firmware_version)));
	AddInfoMessage(_T("PrinterSerial: ")   + CString(PrinterInfo.printer_serial, sizeof(PrinterInfo.printer_serial)));
	AddInfoMessage(_T("ModelName: ")       + CString(PrinterInfo.model_name, sizeof(PrinterInfo.model_name)));
	temp_string.Format(_T("PrinterPartnerCode: %d"), PrinterInfo.printer_partner_code);
	AddInfoMessage(temp_string);
	temp_string.Format(_T("CapabilityFlags: %d"), PrinterInfo.capability_flags);
	AddInfoMessage(temp_string);
	AddInfoMessage(_T("Manufacturer: ") + CString(PrinterInfo.manufacturer, sizeof(PrinterInfo.manufacturer)));
	temp_string.Format(_T("TransferTargetTemp: %d"), PrinterInfo.transfer_target_temperature);
	AddInfoMessage(temp_string);
	temp_string.Format(_T("TransferActualTemp: %d"), PrinterInfo.transfer_actual_temperature);
	AddInfoMessage(temp_string);
	
	temp_string.Format(_T("TotalCards: %d"), PrinterInfo.total_cards);
	AddInfoMessage(temp_string);
	temp_string.Format(_T("TotalPanels: %d"), PrinterInfo.total_panels);
	AddInfoMessage(temp_string);
	temp_string.Format(_T("CardsOnPrinthead: %d"), PrinterInfo.cards_on_printhead);
	AddInfoMessage(temp_string);
	temp_string.Format(_T("PanelsOnPrinthead: %d"), PrinterInfo.panels_on_printhead);
	AddInfoMessage(temp_string);

	temp_string.Format(_T("CardsLowLevel: %d"), PrinterInfo.cards_low);
	AddInfoMessage(temp_string);
	AddInfoMessage(_T("ColourName: ") + CString(PrinterInfo.colour_name, sizeof(PrinterInfo.colour_name)));
	temp_string.Format(_T("ColourTotalPrints: %d"), PrinterInfo.colour_total_prints);
	AddInfoMessage(temp_string);
	temp_string.Format(_T("ColourPrintsRemaining: %d"), PrinterInfo.colour_prints_remaining);
	AddInfoMessage(temp_string);
	temp_string.Format(_T("ColourPartnerCode: %d"), PrinterInfo.colour_partner_code);
	AddInfoMessage(temp_string);
	AddInfoMessage(_T("TransferName: ") + CString(PrinterInfo.transfer_name, sizeof(PrinterInfo.transfer_name)));
	temp_string.Format(_T("TransferTotalPrints: %d"), PrinterInfo.transfer_total_prints);
	AddInfoMessage(temp_string);
	temp_string.Format(_T("TransferPrintsRemaining: %d"), PrinterInfo.transfer_prints_remaining);
	AddInfoMessage(temp_string);
	temp_string.Format(_T("TransferPartnerCode: %d"), PrinterInfo.transfer_partner_code);
	AddInfoMessage(temp_string);

	temp_string.Format(_T("ErrorCode: %d"), PrinterInfo.error_code);
	AddInfoMessage(temp_string);
	temp_string.Format(_T("ErrorContext: %d"), PrinterInfo.error_context);
	AddInfoMessage(temp_string);

	temp_string.Format(_T("CardsBetweenPrompts: %d"), PrinterInfo.cards_between_prompts);
	AddInfoMessage(temp_string);
	temp_string.Format(_T("CleaningOverdue: %d"), PrinterInfo.cleaning_overdue);
	AddInfoMessage(temp_string);
	temp_string.Format(_T("CardsSinceClean: %d"), PrinterInfo.cards_since_clean);
	AddInfoMessage(temp_string);
	temp_string.Format(_T("PanelsSinceClean: %d"), PrinterInfo.panels_since_clean);
	AddInfoMessage(temp_string);
	temp_string.Format(_T("CleaningCycles: %d"), PrinterInfo.cleaning_cycles);
	AddInfoMessage(temp_string);

	temp_string.Format(_T("LaminateActualTemperature: %d"), PrinterInfo.laminate_actual_temperature);
	AddInfoMessage(temp_string);
	temp_string.Format(_T("LaminateTargetTemperature: %d"), PrinterInfo.laminate_target_temperature);
	AddInfoMessage(temp_string);
	temp_string.Format(_T("LaminateType: %d"), PrinterInfo.laminate_type);
	AddInfoMessage(temp_string);
	temp_string.Format(_T("CardSpeed: %d"), PrinterInfo.card_speed);
	AddInfoMessage(temp_string);
	AddInfoMessage(_T(" "));
}

//****************************************************************************

void CInfoPage::OnBnClickedSDKVersionBtn()
{
	CWaitCursor wait;

	//Get SDK function address
	PFNIDVERSION pFnVersion = (PFNIDVERSION)GetProcAddress(Parent->hLib, "ID_SDKVersion");
	if (!pFnVersion)
	{
		FUNCTION_NOT_ACCESSED(GetSDKVersion);
	}

	else
	{
		//Call the SDK to get the version information
		SDKVERSION SDKVersion;
		int SDKReturn = (*pFnVersion)(Parent->hSession, &SDKVersion);
		if (SDKReturn != ID_SUCCESS)
		{
			DISPLAY_ERROR(GetVersion, SDKReturn);
		}

		else
		{
			//Update the message box
			CString sMsg;
			sMsg.Format(_T("Version: %d.%d.%d.%d"), SDKVersion.Major,
													SDKVersion.Minor,
													SDKVersion.Build,
													SDKVersion.Private);
			AddInfoMessage(sMsg);
			AddInfoMessage(_T(" "));
		}
	}
}

//****************************************************************************

void CInfoPage::OnBnClickedConnectionTypeBtn()
{
	CWaitCursor wait;

	//Get SDK function address
	PFNIDCONNECTION pFnConnection = (PFNIDCONNECTION)GetProcAddress(Parent->hLib, "ID_ConnectionType");
	if (!pFnConnection)
	{
		FUNCTION_NOT_ACCESSED(ConnectionType);
	}

	else
	{
		//Call the SDK to get the connection type
		int SDKReturn = (*pFnConnection)(Parent->hSession);

		//Update the message box
		switch (SDKReturn)
		{
		case ID_PORT_USB: 	AddInfoMessage(_T("Connection: USB"));      break;
		case ID_PORT_TCPIP: AddInfoMessage(_T("Connection: ETHERNET")); break;
		case ID_PORT_FILE:  AddInfoMessage(_T("Connection: FILE"));     break;
		default:            AddInfoMessage(_T("Connection: UNKNOWN"));  break;
		}

		AddInfoMessage(_T(" "));
	}
}

//****************************************************************************

void CInfoPage::OnBnClickedBtnPrintertype()
{
	//Get the SDK function address
	PFNIDPRNTYPE pFnPrnType = (PFNIDPRNTYPE)GetProcAddress(Parent->hLib, "ID_PrinterType");
	if (!pFnPrnType)
	{
		FUNCTION_NOT_ACCESSED(PrinterType);
	}

	else
	{
		//Call the SDK to get the printer model
		switch ((*pFnPrnType)(Parent->hSession))
		{
		case ID_RIOTANGO:  AddInfoMessage(_T("Printer Type - RioTango"));           break;
		case ID_AOTA:      AddInfoMessage(_T("Printer Type - Aota"));               break;
		case ID_ENDURO:    AddInfoMessage(_T("Printer Type - Enduro Family"));      break;
		case ID_ULTIMA:    AddInfoMessage(_T("Printer Type - Ultima"));             break;
		case ID_RIOPRO360: AddInfoMessage(_T("Printer Type - Rio Pro 360 Family")); break;
		default:           AddInfoMessage(_T("Printer Type - UNKNOWN"));            break;
		}
		AddInfoMessage(_T(" "));
	}
}

//****************************************************************************

void CInfoPage::OnBnClickedPrinterModelBtn()
{
	//Get the SDK function address
	PFNIDPRNMODEL pFnPrnModel = (PFNIDPRNMODEL)GetProcAddress(Parent->hLib, "ID_PrinterModel");
	if (!pFnPrnModel)
	{
		FUNCTION_NOT_ACCESSED(PrinterModel);
	}

	else
	{
		//Call the SDK to get the printer model
		DWORD model = (*pFnPrnModel)(Parent->hSession);

		if (model & ID_MOD_ULTIMA) AddInfoMessage(_T("Printer - Ultima"));
		else                            AddInfoMessage(_T("Printer - Unknown"));

		AddInfoMessage(_T("Capability:"));
		if (model & ID_FN_MAGNETIC)    AddInfoMessage(_T("  - Mag Encoding"));
		if (model & ID_FN_DUPLEX)      AddInfoMessage(_T("  - Duplex"));
		if (model & ID_FN_CHIP)        AddInfoMessage(_T("  - Chip Encoding"));
		if (model & ID_FN_ETHERNET)    AddInfoMessage(_T("  - Ethernet"));
		if (model & ID_FN_CONTACTLESS) AddInfoMessage(_T("  - Contactless Encoding"));
		if (model & ID_FN_LAMINATE)    AddInfoMessage(_T("  - Laminator"));

		AddInfoMessage(_T(" "));
	}
}

//****************************************************************************

void CInfoPage::OnBnClickedSDKBitsBtn()
{
	//Get the SDK function address
	PFNIDSDKBITS pFnSDKBits = (PFNIDSDKBITS)GetProcAddress(Parent->hLib, "ID_SDKBits");
	if (!pFnSDKBits)
	{
		FUNCTION_NOT_ACCESSED(SDKBits);
	}
	else
	{
		CString tempString;
		tempString.Format(_T("%d"), (*pFnSDKBits)());
		AddInfoMessage(tempString + _T(" Bit SDK"));
		AddInfoMessage(_T(""));
	}
}

//****************************************************************************

void CInfoPage::OnBnClickedTemperatureBtn()
{
	//Get the SDK function address
	PFNIDTEMP pFnTemp = (PFNIDTEMP)GetProcAddress(Parent->hLib, "ID_Temperature");
	if (!pFnTemp)
	{
		FUNCTION_NOT_ACCESSED(Temperature);
	}

	else
	{
		//Call the SDK to get the temperature status
		BOOL Status;
		ID_RETURN SDKReturn = (*pFnTemp)(Parent->hSession, 
										 ID_TEMPERATURE_TRANSFER, 
										 &Status);
		if (SDKReturn != ID_SUCCESS)
		{
			DISPLAY_ERROR(Temperature, SDKReturn);
		}

		else
		{
			CString temp_string = Status ? _T("Ready") : _T("Preheat");
			AddInfoMessage(_T("Transfer Temperature: ") + temp_string);
			AddInfoMessage(_T(" "));
		}
	}
}
